/*****************************************************************************
*
*  Copyright 2019 NXP
* All Rights Reserved
*
*****************************************************************************
*
* THIS SOFTWARE IS PROVIDED BY NXP "AS IS" AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
* OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
* IN NO EVENT SHALL NXP OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
* INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
* STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
* IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
* THE POSSIBILITY OF SUCH DAMAGE.
*
****************************************************************************/

#include <opencv2/opencv.hpp>
#include <umat.hpp>
#include <iostream>
#include <ostream>

#include "../../A53_gen/inc/apu_orbmatchdescriptors0_process_controller.hpp"

using namespace cv;
using namespace std;
using namespace apugen;

APU_OrbMatchDescriptors0_Process_Controller::APU_OrbMatchDescriptors0_Process_Controller(int32_t apex_id) {
#ifdef APEX2_EMULATE
	pProc = new ORBMATCHDESCRIPTORS_PI((APEX_ID)apex_id);
#else 
	pProc = new ORBMATCHDESCRIPTORS_PI(apex_id);
#endif
}

APU_OrbMatchDescriptors0_Process_Controller::~APU_OrbMatchDescriptors0_Process_Controller() {
	delete pProc;
}

int32_t APU_OrbMatchDescriptors0_Process_Controller::Init() {
	int32_t lRetVal = 0;
	lRetVal |= pProc->Initialize();

	return lRetVal;
}

int32_t APU_OrbMatchDescriptors0_Process_Controller::Connect(vsdk::UMat& dataInput1, vsdk::UMat& dataInput0, vsdk::UMat& dataInputConfig, vsdk::UMat& dataOutput0, vsdk::UMat& dataOutput1) {
int32_t lRetVal = 0;
lRetVal |= pProc->ConnectIO(GR_INPUT1_IN, dataInput1);	
lRetVal |= pProc->ConnectIO(GR_INPUT0_IN, dataInput0);	
lRetVal |= pProc->ConnectIO(GR_INPUTCONFIG_IN, dataInputConfig);	
lRetVal |= pProc->ConnectIO(GR_OUTPUT0_OUT, dataOutput0);
lRetVal |= pProc->ConnectIO(GR_OUTPUT1_OUT, dataOutput1);


	return lRetVal;
}

int32_t APU_OrbMatchDescriptors0_Process_Controller::Start() {
	return pProc->Start();
}

int32_t APU_OrbMatchDescriptors0_Process_Controller::Wait() {
	return pProc->Wait();
}

